package kochModel.visitor;

import lrs.*;
import kochModel.*;
import fp.*;

public class GrowVisitor implements IKochVisitor<Object, IFactory> {
  
  public static final GrowVisitor Singleton = new GrowVisitor();
  
  private GrowVisitor() {}
    
  private  IMapAlgo<Koch, IFactory> _mapAlgo = new IMapAlgo<Koch, IFactory>() {
        public boolean apply(Koch host, IFactory... fac) {
          host.execute(GrowVisitor.this, fac);
          return true;
        }
        public void noApply(IFactory... fac) {
        }
      };
  
  public Object baseCase(Koch host, IFactory... fac) {
    host.shareState(fac[0].makeInduct(host.getA(),host.getB()));
    return null;
  }
  
  public Object inductCase(Koch host, final IFactory... fac) {
    host.map(_mapAlgo, fac);
    return null;
  }
  
}